
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Nov 29 18:42:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version ODRM_TLK_ATP_menu.c#1:csrc:1
   *  \author Sagitb
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/***** Include Files **************/
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Stdio.h"
#include "MW_ATP_UTIL_funcs.h"
#include "ODRM_TLK_ATP_Defines.h" 
#include "ODRM_TLK_ATP_UTIL.h"
#include "ODRM_TLK_ATP_tests.h"
#include "KMNG_API.h" 
#include "tlk_odrm_version.h"

/******** Defines ************/

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_ODRM_Run_All_Tests      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function runs all the tests
*  
******************************************************************************/
DxError_t TST_ATP_TLK_ODRM_Run_All_Tests( void )
{
  /********* TST Variables Definitions ************/
  DxError_t          TST_Error = DX_SUCCESS, TST_TempError = DX_SUCCESS;

  ATP_LOG_TST_PRINT((MW_ATP_MSG,"******************************************************* \n"));
  ATP_LOG_TST_PRINT((MW_ATP_MSG,"************ Run All KMNG ATP tests ******************* \n"));      
  ATP_LOG_TST_PRINT((MW_ATP_MSG,"******************************************************* \n \n"));

  /* Initializing the KMNG in case this function is called w/o the menu
	 multiple calls to KMNG_Init are assumed to have no effect.	        */
  TST_Error = KMNG_Init();
 TST_ATP_CHECK_ERROR_RETURN(TST_Error,
											   "KMNG_Init",
											   "!!!!!!!!!",
											   "!!!!!!!!!");

  TST_Error = TST_ATP_TLK_ODRM_KmacAndKmekEncryptUnderKri();
  TST_TempError = TST_TempError + TST_Error;
 
  TST_Error = TST_ATP_TLK_ODRM_KmacAndKrekDeriveUnderDomainKey();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_TLK_ODRM_AesUnwrapAndStore();
  TST_TempError = TST_TempError + TST_Error;

  TST_Error = TST_ATP_TLK_ODRM_AesKeyDecryptAndStoreAllModes();
  TST_TempError = TST_TempError + TST_Error;

 
  TST_Error = TST_ATP_TLK_ODRM_KmacAndKrekDeriveUnderDeviceKey();
  TST_TempError = TST_TempError + TST_Error;


  TST_Error = TST_ATP_TLK_ODRM_KmacAndKdDeriveUnderDeviceKey();
  TST_TempError = TST_TempError + TST_Error;
  
    

  /*Check if all tests pass*/
  if (TST_TempError != TST_PASS )
  {
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!! ONE OR MORE OF THE ATP TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
	 return TST_FAIL;
  }
  else
  {
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n \n**********************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"* ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP ***\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"**********************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"*** ALL OF THE ATP  TESTS PASS     :-)         *****\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"**********************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"* ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP ***\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"**********************\n"));
  }
EXIT_ON_ERROR:
  return TST_Error;
}
/*****************************************************************************
* Function Name:                                                           
*  ODRM_TLK_ATP_menu      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function runs the ATP menu
*  
******************************************************************************/

 DxError_t ODRM_TLK_ATP_menu (void)

 {

   DxInt_t     Var;
   DxStatus TST_TestStatus = DX_SUCCESS;
   TLK_ODRMVersion_t TST_Version;

    #ifdef _DEBUG
        TST_TestStatus =  DX_VOS_DbgPrint_SetDebugLevel(0);
    #endif

      TST_TestStatus = KMNG_Init();
      
      TST_ATP_CHECK_ERROR_RETURN(TST_TestStatus,"KMNG_Init", "ODRM_TLK_ATP_menu","ODRM_TLK_ATP_menu");
     

       TST_TestStatus =TLK_ODRM_VersionGet(&TST_Version);

       TST_ATP_CHECK_ERROR_RETURN(TST_TestStatus,
                        "TLK_ODRM_VersionGet",
                        "ODRM_TLK_ATP_menu",
                        "ODRM_TLK_ATP_menu");
      
        ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n-----------------------------------------------------"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n------------[OMA DRM Toolkit Version]----------------"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n-----------------------------------------------------"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n %s %c.%d.%d.%d",TST_Version.tlk_odrm.componentName,
        														   TST_Version.tlk_odrm.typeVer,
        														   TST_Version.tlk_odrm.majorVer,
        														   TST_Version.tlk_odrm.minorVer,
        														   TST_Version.tlk_odrm.subVer));
        ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n-----------------------------------------------------"));

      while(1)
      {
        while(1)
        {
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n\n              -- DISCRETIX LTD 2007 --           "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       -- OMA DRM Toolkit Acceptance tests --        "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------[ Main Tests Menu ]-----------------"));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [1] - Kmac and Kmek Encrypt under Kri test  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [2] - Kmac And Kmek Derive Under Domain Key test "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [3] - Aes Unwrap And Store test  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [4] - Aes Key Decrypt And Store test  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [5] - Kmac And Krek Derive Under Device Key test  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [6] - Kmac And KD Derive Under Device Key test  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [T] - Run All Tetsts  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [Z] - End Of Tests  "));
          ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n"));
         
          GET_NON_WHITE_SPACE_CHAR(Var);

          DX_VOS_Printf("\n Test = %c\n",Var);

          if (Var<='z')
            break;
          else
            DX_VOS_Printf("\n Error[%d]  Please select '1'-'XX'\n\n",Var);
        }

        switch(Var)
        {
        case '1':
          TST_ATP_TLK_ODRM_KmacAndKmekEncryptUnderKri();
          break;
        case '2':
          TST_ATP_TLK_ODRM_KmacAndKrekDeriveUnderDomainKey();
          break;
        case '3':
          TST_ATP_TLK_ODRM_AesUnwrapAndStore();
          break;
        case '4':
          TST_ATP_TLK_ODRM_AesKeyDecryptAndStoreAllModes();
          break;
        case '5':
          TST_ATP_TLK_ODRM_KmacAndKrekDeriveUnderDeviceKey();
          break;
        case '6':
          TST_ATP_TLK_ODRM_KmacAndKdDeriveUnderDeviceKey();
          break;
       case 'T':
          TST_ATP_TLK_ODRM_Run_All_Tests();
         break;
        }

        if(Var =='Z')
          break;
      }

  EXIT_ON_ERROR: 

  return TST_TestStatus;
  
}



